/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;

public class ModelProvider
implements DataProvider {
    private static final Logger f_125095_ = LogUtils.getLogger();
    private static final Gson f_125096_ = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator f_125097_;

    public ModelProvider(DataGenerator p_125100_) {
        this.f_125097_ = p_125100_;
    }

    @Override
    public void m_6865_(HashCache p_125103_) {
        Path $$1 = this.f_125097_.m_123916_();
        HashMap $$2 = Maps.newHashMap();
        Consumer<BlockStateGenerator> $$3 = p_125120_ -> {
            Block $$2 = p_125120_.m_6968_();
            BlockStateGenerator $$3 = $$2.put($$2, p_125120_);
            if ($$3 != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + $$2);
            }
        };
        HashMap $$4 = Maps.newHashMap();
        HashSet $$5 = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> $$6 = (p_125123_, p_125124_) -> {
            Supplier $$3 = $$4.put(p_125123_, p_125124_);
            if ($$3 != null) {
                throw new IllegalStateException("Duplicate model definition for " + p_125123_);
            }
        };
        Consumer<Item> $$7 = $$5::add;
        new BlockModelGenerators($$3, $$6, $$7).m_124510_();
        new ItemModelGenerators($$6).m_125083_();
        List $$8 = Registry.f_122824_.m_123024_().filter(p_125117_ -> !$$2.containsKey(p_125117_)).collect(Collectors.toList());
        if (!$$8.isEmpty()) {
            throw new IllegalStateException("Missing blockstate definitions for: " + $$8);
        }
        Registry.f_122824_.forEach(p_125128_ -> {
            Item $$3 = Item.f_41373_.get(p_125128_);
            if ($$3 != null) {
                if ($$5.contains($$3)) {
                    return;
                }
                ResourceLocation $$4 = ModelLocationUtils.m_125571_($$3);
                if (!$$4.containsKey($$4)) {
                    $$4.put($$4, new DelegatedModel(ModelLocationUtils.m_125576_(p_125128_)));
                }
            }
        });
        this.m_125104_(p_125103_, $$1, $$2, ModelProvider::m_125109_);
        this.m_125104_(p_125103_, $$1, $$4, ModelProvider::m_125112_);
    }

    private <T> void m_125104_(HashCache p_125105_, Path p_125106_, Map<T, ? extends Supplier<JsonElement>> p_125107_, BiFunction<Path, T, Path> p_125108_) {
        p_125107_.forEach((p_125133_, p_125134_) -> {
            Path $$5 = (Path)p_125108_.apply(p_125106_, p_125133_);
            try {
                DataProvider.m_123920_(f_125096_, p_125105_, (JsonElement)p_125134_.get(), $$5);
            }
            catch (Exception $$6) {
                f_125095_.error("Couldn't save {}", (Object)$$5, (Object)$$6);
            }
        });
    }

    private static Path m_125109_(Path p_125110_, Block p_125111_) {
        ResourceLocation $$2 = Registry.f_122824_.m_7981_(p_125111_);
        return p_125110_.resolve("assets/" + $$2.m_135827_() + "/blockstates/" + $$2.m_135815_() + ".json");
    }

    private static Path m_125112_(Path p_125113_, ResourceLocation p_125114_) {
        return p_125113_.resolve("assets/" + p_125114_.m_135827_() + "/models/" + p_125114_.m_135815_() + ".json");
    }

    @Override
    public String m_6055_() {
        return "Block State Definitions";
    }
}

